/**
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import './scss/admin.scss'

import { createApp } from 'vue'
import { createPinia } from 'pinia'
import { waitContainer } from './lib/dom.js'

import UserSettings from './pages/UserSettings'

waitContainer('#side-menu-user-settings').then((selector) => {
  const pinia = createPinia()
  const app = createApp(UserSettings)
  app.use(pinia)
  app.mixin({ methods: { t, n } })
  app.mount(selector)
})
