(function() {
    var sideMenuContainer = jQuery('<div id="side-menu-container">')
    var sideMenuOpener = jQuery('<button class="side-menu-opener"></button>')
    var sideMenu = jQuery('<div id="side-menu">')
    var body = jQuery('body')
    var html = jQuery('html')
    var isTouchDevice = window.matchMedia("(pointer: coarse)").matches

    <?php if ($_['big-menu']): ?>
        sideMenu.attr('data-bigmenu', '1')
    <?php endif; ?>

    var targetBlankApps = <?php echo json_encode($_['target-blank-apps']) ?>;

    body.on('side-menu.apps', function(e, apps) {
        <?php if ($_['hide-when-no-apps']): ?>
            sideMenu = jQuery('#side-menu')

            if (apps.length === 0) {
                sideMenu.removeClass('open')
                sideMenu.addClass('hide')
                sideMenuOpener.addClass('hide')
            } else {
                sideMenu.removeClass('hide')
                sideMenuOpener.removeClass('hide')
            }

            <?php if ($_['always-displayed'] && !$_['big-menu']): ?>
                if (apps.length === 0) {
                    html.removeClass('side-menu-always-displayed');
                } else {
                    html.addClass('side-menu-always-displayed');
                }
            <?php endif; ?>
        <?php else: ?>
            <?php if ($_['always-displayed'] && !$_['big-menu']): ?>
                if (apps.length === 0) {
                    html.removeClass('side-menu-always-displayed');
                } else {
                    html.addClass('side-menu-always-displayed');
                }
            <?php endif; ?>
        <?php endif; ?>
    })

    body.on('side-menu.ready', function() {
        sideMenu = jQuery('#side-menu')

        var headerMenuOpener = jQuery('#header .side-menu-opener')
        var sideMenuOpener = jQuery('#side-menu .side-menu-opener')

        sideMenuFocus = function() {
            var a = sideMenu.find('.side-menu-app.active a')

            if (a.length === 0) {
                a = sideMenu.find('.side-menu-app:first-child a')
            }

            if (a.length > 0) {
                a.focus()
            }
        }

        <?php if ($_['opener-hover'] || ($_['always-displayed'] && !$_['big-menu'])): ?>
            var sideMenuMouseLeave = function() {
                sideMenu
                    .removeClass('open')
                    .off('mouseleave', sideMenuMouseLeave)
            }

            var sideMenuMouseEnter = function() {
                sideMenu.on('mouseleave', sideMenuMouseLeave)
            }

            var sideMenuOpenerMouseEnter = function() {
                sideMenu
                    .addClass('open')
                    .on('mouseenter', sideMenuMouseEnter)

                sideMenuFocus()
            }

            if (!isTouchDevice) {
                <?php if ($_['opener-hover']): ?>
                    headerMenuOpener.on('mouseenter', sideMenuOpenerMouseEnter)

                    sideMenu.addClass('hide-opener')
                <?php else: ?>
                    sideMenu.on('mouseleave', sideMenuMouseLeave)
                    sideMenu.on('mouseenter', sideMenuOpenerMouseEnter)
                <?php endif ?>
            }
        <?php endif; ?>

        headerMenuOpener.on('click', function() {
            sideMenu.addClass('open')
            sideMenu.find('.side-menu-app.active a').focus()
        })

        <?php if ($_['always-displayed'] && !$_['big-menu']): ?>
            sideMenuOpener.on('click', function() {
                sideMenu.toggleClass('open')
            })
        <?php else: ?>
            sideMenuOpener.on('click', function() {
                sideMenu.removeClass('open')
            })
        <?php endif; ?>

        jQuery(document).keydown(function(e) {
            var key = e.key || e.keyCode

            if ((key === 'o' || key === 79) && e.ctrlKey === true) {
                e.preventDefault()

                sideMenu.toggleClass('open')
                sideMenuFocus()
            }
        })
    })

    body.append(sideMenuContainer)
    sideMenuContainer.append(sideMenu)

    <?php if ($_['loader-enabled'] === true): ?>
        <?php require_once __DIR__.'/_loaderEnabled.js'; ?>
    <?php endif; ?>

    <?php if ($_['opener-position'] === 'before'): ?>
        sideMenuOpener.insertBefore('#nextcloud')
    <?php else: ?>
        sideMenuOpener.insertAfter('#nextcloud')
    <?php endif; ?>

    <?php if (!empty($_['top-menu-apps'])): ?>
        var topMenuApps = <?php echo json_encode($_['top-menu-apps']); ?>;

        <?php require_once __DIR__.'/_topMenuApps.js'; ?>
    <?php endif; ?>

    <?php if ($_['always-displayed'] && !$_['big-menu']): ?>
        <?php require_once __DIR__.'/_alwaysDisplayed.js'; ?>
    <?php endif; ?>
})();
