var menuCache = null

var updateTopMenu = function() {
    var breakpointMobileWidth = 1024
    var menu = jQuery('#appmenu')
    var apps = menu.find('li')
    var minAppsDesktop = 8
    var usePercentualAppMenuLimit = 0.8
    var isMobile = jQuery(window).width() < breakpointMobileWidth
    var lastShownApp = null
    var appShown = []
    var moreApps = jQuery('#more-apps')
    var navigation = jQuery('#navigation')
    var navigationApps = jQuery('#apps ul')
    var appCount = null

    var currentMenuCache = menu.html() + menu.next().html()

    if (currentMenuCache === menuCache) {
        return
    }

    navigationApps.html('')

    apps.each(function(i, app) {
        var dataId = app.getAttribute('data-id')

        if (dataId === null) {
            return
        }

        if (topMenuApps.indexOf(dataId) === -1) {
            app.classList.add('hidden')
            app.classList.add('app-hidden')
        } else {
            app.classList.remove('hidden')
            app.classList.add('app-external-site')
            appShown.push(app)
            navigationApps.append(app.outerHTML)
        }

        if (targetBlankApps.indexOf(dataId) !== -1) {
            jQuery(app).children('a').attr('target', '_blank');
        }
    })

    var rightHeaderWidth = jQuery('.header-right').outerWidth()
    var headerWidth = jQuery('header').outerWidth()
    var availableWidth = headerWidth - jQuery('#nextcloud').outerWidth()
                            - jQuery('#header .side-menu-opener').outerWidth()
                            - (rightHeaderWidth > 230 ? rightHeaderWidth : 230)

    if (!isMobile) {
        availableWidth = availableWidth * usePercentualAppMenuLimit
    }

    appCount = Math.floor(availableWidth / jQuery('#appmenu li').width())

    if (isMobile && appCount > minAppsDesktop) {
        appCount = minAppsDesktop
    } else if (!isMobile && appCount < minAppsDesktop) {
        appCount = minAppsDesktop
    }

    if (appCount === 0) {
        menu.addClass('hidden')
    }

    menu.removeClass('hidden')
    menu.css('opacity', 1)

    if (appShown.length - 1 - appCount >= 1) {
        appCount--
    }

    moreApps.find('a').removeClass('active')

    var k = 0
    var notInHeader = 0
    var name

    jQuery(appShown).each(function(i, app) {
        app = jQuery(app)
        name = app.data('id')

        if (k < appCount && appCount > 0) {
            app.removeClass('hidden')
            lastShownApp = app

            jQuery('#apps li[data-id=' + name + '].app-external-site').addClass('in-header')
        } else {
            app.addClass('hidden')
            notInHeader++

            jQuery('#apps li[data-id=' + name + '].app-external-site').removeClass('in-header')

            if (appCount > 0 && app.children('a').hasClass('active')) {
                lastShownApp.addClass('hidden')
                app.removeClass('hidden')
                notInHeader++

                jQuery('#apps li[data-id=' + name + '].app-external-site')
                    .removeClass('in-header')
                    .addClass('in-header')
            }
        }

        k++
    })

    jQuery('#apps li.app-external-site').each(function(i, app) {
        app = jQuery(app)
        var appId = app.attr('data-id')

        if (app.hasClass('in-header')) {
            app.find('svg').find('defs').remove()
        } else {
            var svg = app.find('svg');

            if (svg.find('defs').length > 0) {
                return;
            }

            var defs = `
                <defs>
                    <filter id="invertMenuMore-${appId}">
                        <feColorMatrix in="SourceGraphic" type="matrix" values="-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0"></feColorMatrix>
                    </filter>
                </defs>`

            svg.prepend(defs)
            svg.find('image').attr('filter', `url(#invertMenuMore-${appId})`)

            var html = svg.get(0).innerHTML.replace(/fecolormatrix/g, 'feColorMatrix');

            svg.html(html)
        }
    })

    if (notInHeader === 0) {
        moreApps.hide()
        navigation.hide()
    } else {
        moreApps.show()
    }

    menuCache = menu.html() + menu.next().html()
}

setInterval(updateTopMenu, 50)
