<?php

namespace OCA\SideMenu\Service;

use OC_App;
use OCP\L10N\IFactory;

/**
 * class AppRepository.
 *
 * @author Simon Vieille <simon@deblan.fr>
 */
class AppRepository
{
    /**
     * @var OC_App
     */
    protected $ocApp;

    /**
     * @var IFactory
     */
    protected $l10nFactory;

    public function __construct(OC_App $ocApp, IFactory $l10nFactory)
    {
        $this->ocApp = $ocApp;
        $this->l10nFactory = $l10nFactory;
    }

    /**
     * Retrieves visibles apps.
     *
     * @return array
     */
    public function getVisibleApps()
    {
        $navigation = $this->ocApp->getNavigation();
        $apps = $this->ocApp->listAllApps();
        $visibleApps = [];

        foreach ($apps as $app) {
            $id = $app['id'];

            foreach ([$app['id'], $app['id'].'_index'] as $id) {
                if (isset($navigation[$id])) {
                    $app['name'] = $this->l10nFactory->get($id)->t($app['name']);
                    $app['href'] = $navigation[$id]['href'];
                    $app['icon'] = $navigation[$id]['icon'];

                    $visibleApps[$id] = $app;
                }
            }
        }

        foreach ($navigation as $app) {
            if ('external_index' === substr($app['id'], 0, 14)) {
                $visibleApps[$app['id']] = [
                    'id' => $app['id'],
                    'name' => $this->l10nFactory->get($app['id'])->t($app['name']),
                    'href' => $app['href'],
                    'icon' => $app['icon'],
                    'category' => [
                        'external_links',
                    ],
                ];
            } elseif ('files' === $app['id']) {
                $visibleApps[$app['id']] = [
                    'id' => $app['id'],
                    'name' => $this->l10nFactory->get($app['id'])->t($app['name']),
                    'href' => $app['href'],
                    'icon' => $app['icon'],
                    'category' => [],
                ];
            }
        }

        usort($visibleApps, function ($a, $b) {
            return ($a['name'] < $b['name']) ? -1 : 1;
        });

        return $visibleApps;
    }
}
