<?php
/**
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

script('side_menu', 'admin');
style('side_menu', 'admin');
style('side_menu', 'support');

$choicesYesNo = [
    'No' => '0',
    'Yes' => '1',
];

?>

<div id="side-menu-section">
    <div class="section">
        <h2>
            <?php p($l->t('Menu')); ?>
        </h2>

        <div>
            <label for="side-menu-enabled">
                <?php p($l->t('Enable the side menu')); ?>
            </label>
        </div>

        <p>
            <em><?php echo $l->t('Use the shortcut <span class="keyboard-key">Ctrl</span>+<span class="keyboard-key">o</span> to open and to hide the side menu. Use <span class="keyboard-key">tab</span> to navigate.'); ?></em>
        </p>

        <div>
            <select id="side-menu-enabled" name="enabled" class="side-menu-setting" data-personal>
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['enabled']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="side-menu-target-blank">
                <?php p($l->t('Open apps in new tab')); ?>
            </label>
        </div>

        <div>
            <?php $choices = [
                'Use the global setting' => '1',
                'Use my selection' => '2',
            ]; ?>

            <select id="side-menu-loader-enabled" name="target-blank-mode" class="side-menu-setting" data-personal>
                <?php foreach ($choices as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['target-blank-mode']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <p>
            <a class="side-menu-toggler" data-target="#target-blank-apps" href="#_">
                🖱️ <?php p($l->t('Show and hide the list of applications')); ?>
            </a>
        </p>

        <div class="side-menu-setting" data-name="target-blank-apps" id="target-blank-apps" data-personal data-checkbox style="display: none">
            <?php foreach ($_['apps'] as $app): ?>
                <div>
                    <input
                        type="checkbox"
                        name="target-blank-apps[]"
                        value="<?php echo $app['id'] ?>"
                        id="target-blank-app-<?php echo $app['id'] ?>"
                        <?php if (in_array($app['id'], $_['target-blank-apps'])): ?>checked<?php endif; ?>
                    />

                    <label for="target-blank-app-<?php echo $app['id'] ?>">
                        <?php echo p($l->t($app['name'])); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="section">
        <h2>
            <?php p($l->t('Top menu')); ?>
        </h2>
        <div>
            <label for="side-menu-top-menu-apps">
                <?php p($l->t('Apps that not must be moved in the side menu')); ?>
            </label>
        </div>

        <p>
            <em>
                <?php p($l->t('If there is no selection then the global configuration is applied.')); ?>
            </em>
        </p>

        <p>
            <a class="side-menu-toggler" data-target="#top-menu-apps" href="#_">
                🖱️ <?php p($l->t('Show and hide the list of applications')); ?>
            </a>
        </p>

        <div class="side-menu-setting" data-name="top-menu-apps" data-checkbox data-personal id="top-menu-apps" style="display: none">
            <?php foreach ($_['apps'] as $app): ?>
                <div>
                    <input
                        type="checkbox"
                        name="top-menu-apps[]"
                        value="<?php echo $app['id'] ?>"
                        id="top-menu-app-<?php echo $app['id'] ?>"
                        <?php if (in_array($app['id'], $_['top-menu-apps'])): ?>checked<?php endif; ?>
                    />

                    <label for="top-menu-app-<?php echo $app['id'] ?>">
                        <?php echo $app['name'] ?>
                    </label>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="section">
        <button id="side-menu-save" class="btn btn-primary"><?php p($l->t('Save')); ?></button>

        <span id="side-menu-message" class="msg"></span>

        <div style="height: 30px"></div>

        <div>
            <span for="side-menu-opener">
                <?php p($l->t('You like this app and you want to support me?')); ?>

                <a style="margin-left: 10px" target="_blank" href="https://www.buymeacoffee.com/deblan">
                    <button>
                        <?php p($l->t('Buy me a coffee ☕')); ?>
                    </button>
                </a>
            </span>
        </div>
    </div>
</div>
