<?php
/**
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

script('side_menu', 'admin');
style('side_menu', 'admin');
style('side_menu', 'support');

$choicesYesNo = [
    'No' => '0',
    'Yes' => '1',
];

$choicesSizes = [
    'Hidden' => 'hidden',
    'Small' => 'small',
    'Normal' => 'normal',
    'Big' => 'big',
];
?>

<div id="side-menu-section">
    <div class="section">
        <h2>
            <?php p($l->t('Colors')); ?>

            <small><span class="info"><?php p($l->t('Live preview')); ?></span></small>
        </h2>

        <div>
            <label for="side-menu-background-color">
                <?php p($l->t('Background color')); ?>
            </label>
        </div>
        <div>
            <input
                id="side-menu-background-color"
                name="background-color"
                type="color"
                class="side-menu-setting side-menu-setting-live"
                value="<?php print_unescaped($_['background-color']); ?>">
            <input
                id="side-menu-background-color-to"
                name="background-color-to"
                type="color"
                class="side-menu-setting side-menu-setting-live"
                value="<?php print_unescaped($_['background-color-to']); ?>">
        </div>

        <div>
            <label for="side-menu-current-app-background-color">
                <?php p($l->t('Background color of current app')); ?>
            </label>
        </div>
        <div>
            <input
                id="side-menu-current-app-background-color"
                name="current-app-background-color"
                type="color"
                class="side-menu-setting side-menu-setting-live"
                value="<?php print_unescaped($_['current-app-background-color']); ?>">
        </div>

        <div>
            <label for="side-menu-text-color">
                <?php p($l->t('Text color')); ?>
            </label>
        </div>
        <div>
            <input
                id="side-menu-text-color"
                name="text-color"
                type="color"
                class="side-menu-setting side-menu-setting-live"
                value="<?php print_unescaped($_['text-color']); ?>">
        </div>

        <div>
            <label for="side-menu-text-color">
                <?php p($l->t('Loader')); ?>
            </label>
        </div>
        <div>
            <input
                id="side-menu-loader-color"
                name="loader-color"
                type="color"
                class="side-menu-setting"
                value="<?php print_unescaped($_['loader-color']); ?>">
        </div>

        <div>
            <label for="side-menu-icon-invert-filter">
                <?php p($l->t('Icon')); ?>
            </label>
        </div>

        <div>
            <em>
                <?php p($l->t('Same color')); ?>
            </em>

            <input
                type="range"
                min="0" max="100"
                id="side-menu-icon-invert-filter"
                name="icon-invert-filter"
                class="side-menu-setting side-menu-setting-live"
                value="<?php echo $_['icon-invert-filter'] ?>"
            >

            <em>
                <?php p($l->t('Opposite color')); ?>
            </em>
        </div>

        <div>
            <em>
                <?php p($l->t('Transparent')); ?>
            </em>

            <input
                type="range"
                min="0" max="100"
                id="side-menu-icon-opacity"
                name="icon-opacity"
                class="side-menu-setting side-menu-setting-live"
                value="<?php echo $_['icon-opacity'] ?>"
            >

            <em>
                <?php p($l->t('Opaque')); ?>
            </em>
        </div>
    </div>

    <div class="section">
        <h2>
            <?php p($l->t('Opener')); ?>
        </h2>

        <?php
            $choices = [
                'Default' => 'side-menu-opener',
                'Default (dark)' => 'side-menu-opener-dark',
                'Hamburger' => 'side-menu-opener-hamburger',
                'Hamburger (dark)' => 'side-menu-opener-hamburger-dark',
                'Hamburger 2' => 'side-menu-opener-hamburger-2',
                'Hamburger 2 (dark)' => 'side-menu-opener-hamburger-2-dark',
            ];
        ?>

        <div>
            <label for="side-menu-opener">
                <?php p($l->t('Icon')); ?>

                <small><span class="info"><?php p($l->t('Live preview')); ?></span></small>
            </label>
        </div>

        <div>
            <select id="side-menu-opener" name="opener" class="side-menu-setting side-menu-setting-live">
                <?php foreach ($choices as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['opener']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <?php
            $choices = [
                'Before the logo' => 'before',
                'After the logo' => 'after',
            ];
        ?>

        <div>
            <label for="side-menu-opener-position">
                <?php p($l->t('Position')); ?>
            </label>
        </div>

        <div>
            <select id="side-menu-opener-position" name="opener-position" class="side-menu-setting">
                <?php foreach ($choices as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['opener-position']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="side-menu-opener-only">
                <?php p($l->t('Show only the opener (hidden logo)')); ?>
            </label>
        </div>

        <div>
            <select id="side-menu-opener-only" name="opener-only" class="side-menu-setting">
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['opener-only']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="side-menu-hide-when-no-apps">
                <?php p($l->t('Do not display the side menu and the opener if there is no application (eg: public pages).')); ?>
            </label>
        </div>

        <div>
            <select id="side-menu-hide-when-no-apps" name="hide-when-no-apps" class="side-menu-setting">
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['hide-when-no-apps']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>

    <div class="section">
        <h2>
            <?php p($l->t('Panel')); ?>
        </h2>

        <div>
            <label>
                <?php p($l->t('Default')); ?>
            </label>
        </div>

        <?php
            $displays = [
                'default' => !$_['always-displayed'] && !$_['big-menu'],
                'always-displayed' => $_['always-displayed'] && !$_['big-menu'],
                'big-menu' => $_['big-menu'],
            ];
        ?>

        <p>
            <img
                class="side-menu-display <?php echo $displays['default'] ? 'is-active' : '' ?>"
                data-alwaysdiplayed="0"
                data-bigmenu="0"
                src="<?php print_unescaped(image_path('side_menu', 'admin/layout-default.svg')); ?>" alt="<?php p($l->t('Default')); ?>">
        </p>

        <div>
            <label for="side-menu-opener">
                <?php p($l->t('Big menu')); ?>
            </label>
        </div>

        <p><em><?php p($l->t('The big menu is not compatible with AppOrder.')); ?></em></p>

        <p>
            <img
                class="side-menu-display <?php echo $displays['big-menu'] ? 'is-active' : '' ?>"
                data-alwaysdiplayed="0"
                data-bigmenu="1"
                src="<?php print_unescaped(image_path('side_menu', 'admin/layout-big-menu.svg')); ?>" alt="<?php p($l->t('Big menu')); ?>">
        </p>

        <br>

        <div>
            <label for="side-menu-opener">
                <?php p($l->t('Always displayed')); ?>
                <small><span class="warning"><?php p($l->t('Experimental')); ?></span></small>
            </label>
        </div>

        <p><em><?php p($l->t('Not compatible with touch screens.')); ?></em></p>

        <p>
            <img
                class="side-menu-display <?php echo $displays['always-displayed'] ? 'is-active' : '' ?>"
                data-alwaysdiplayed="1"
                data-bigmenu="0"
                src="<?php print_unescaped(image_path('side_menu', 'admin/layout-always-displayed.svg')); ?>" alt="<?php p($l->t('Always displayed')); ?>">
        </p>

        <input type="hidden" class="side-menu-setting" name="always-displayed" id="side-menu-always-displayed" value="<?php echo (int) $_['always-displayed'] ?>">
        <input type="hidden" class="side-menu-setting" name="big-menu" id="side-menu-big-menu" value="<?php echo (int) $_['big-menu'] ?>">

        <br>

        <div>
            <label for="side-menu-opener">
                <?php p($l->t('Open the menu when the mouse is hover the opener (automatically disabled on touch screens)')); ?>
            </label>
        </div>

        <p><em><?php p($l->t('This is the automatic behavior when the menu is always displayed.')); ?></em></p>

        <div>
            <select id="side-menu-opener-hover" name="opener-hover" class="side-menu-setting">
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['opener-hover']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="side-menu-opener">
                <?php p($l->t('Display the logo')); ?>
            </label>
        </div>

        <p><em><?php echo $l->t('This feature is not compatible with the <code>big menu</code> display.'); ?></em></p>
        <p><em><?php p($l->t('The logo will be hidden when the menu is always displayed.')); ?></em></p>

        <div>
            <select id="side-menu-display-logo" name="display-logo" class="side-menu-setting">
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['display-logo']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <p><em><?php p($l->t('Use the avatar instead of the logo')); ?></em></p>

        <div>
            <select id="side-menu-use-avatar" name="use-avatar" class="side-menu-setting">
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['use-avatar']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label>
                <?php p($l->t('Icons and texts')); ?>
            </label>
        </div>

        <div>
            <select id="side-menu-size-icon" name="size-icon" class="side-menu-setting">
                <?php foreach ($choicesSizes as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['size-icon']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?> icon
                    </option>
                <?php endforeach; ?>
            </select>

            <select id="side-menu-size-text" name="size-text" class="side-menu-setting">
                <?php foreach ($choicesSizes as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['size-text']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?> text
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="side-menu-target-blank">
                <?php p($l->t('Open apps in new tab')); ?>
            </label>
        </div>

        <p>
            <a class="side-menu-toggler" data-target="#target-blank-apps" href="#_">
                🖱️ <?php p($l->t('Show and hide the list of applications')); ?>
            </a>
        </p>

        <div class="side-menu-setting" data-name="target-blank-apps" id="target-blank-apps" data-checkbox style="display: none">
            <?php foreach ($_['apps'] as $app): ?>
                <div>
                    <input
                        type="checkbox"
                        name="target-blank-apps[]"
                        value="<?php echo $app['id'] ?>"
                        id="target-blank-app-<?php echo $app['id'] ?>"
                        <?php if (in_array($app['id'], $_['target-blank-apps'])): ?>checked<?php endif; ?>
                    />

                    <label for="target-blank-app-<?php echo $app['id'] ?>">
                        <?php echo p($l->t($app['name'])); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        </div>

        <br>

        <div>
            <label for="side-menu-loader-enabled">
                <?php p($l->t('Loader enabled')); ?>
            </label>
        </div>

        <div>
            <select id="side-menu-loader-enabled" name="loader-enabled" class="side-menu-setting">
                <?php foreach ($choicesYesNo as $label => $value): ?>
                    <option value="<?php echo $value ?>" <?php if ($value === $_['loader-enabled']): ?>selected<?php endif; ?>>
                        <?php echo $l->t($label);  ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>

    <div class="section">
        <h2>
            <?php p($l->t('Top menu')); ?>
        </h2>
        <div>
            <label for="side-menu-top-menu-apps">
                <?php p($l->t('Apps that not must be moved in the side menu')); ?>
            </label>
        </div>

        <p>
            <a class="side-menu-toggler" data-target="#top-menu-apps" href="#_">
                🖱️ <?php p($l->t('Show and hide the list of applications')); ?>
            </a>
        </p>

        <div class="side-menu-setting" data-name="top-menu-apps" id="top-menu-apps" data-checkbox style="display: none">
            <?php foreach ($_['apps'] as $app): ?>
                <div>
                    <input
                        type="checkbox"
                        name="top-menu-apps[]"
                        value="<?php echo $app['id'] ?>"
                        id="top-menu-app-<?php echo $app['id'] ?>"
                        <?php if (in_array($app['id'], $_['top-menu-apps'])): ?>checked<?php endif; ?>
                    />

                    <label for="top-menu-app-<?php echo $app['id'] ?>">
                        <?php echo p($l->t($app['name'])); ?>
                    </label>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="section">
        <h2>
            <?php p($l->t('Tips')); ?>
        </h2>

        <p>
            <em><?php echo $l->t('Use the shortcut <span class="keyboard-key">Ctrl</span>+<span class="keyboard-key">o</span> to open and to hide the side menu. Use <span class="keyboard-key">tab</span> to navigate.'); ?></em>
        </p>
    </div>

    <div class="section">
        <input type="hidden" id="side-menu-cache" name="cache" value="<?php print_unescaped($_['cache']); ?>" class="side-menu-setting">

        <button id="side-menu-save" class="btn btn-primary"><?php p($l->t('Save')); ?></button>

        <span id="side-menu-message" class="msg"></span>

        <div style="height: 30px"></div>

        <div>
            <span for="side-menu-opener">
                <?php p($l->t('You like this app and you want to support me?')); ?>

                <a style="margin-left: 10px" target="_blank" href="https://www.buymeacoffee.com/deblan">
                    <button>
                        <?php p($l->t('Buy me a coffee ☕')); ?>
                    </button>
                </a>
            </span>
        </div>
    </div>
</div>
