var alwaysDisplayed = function() {
    var elements = document.querySelectorAll('*');
    var fixedElements = []

    for (var i in elements) {
        var element = elements[i]

        if (typeof element !== 'object') {
            continue
        }

        var position = window.getComputedStyle(element, null).getPropertyValue('position');

        if (position !== 'fixed') {
            continue
        }

        var id = element.getAttribute('id')

        if (id === 'header' || id === 'side-menu' || id === 'side-menu-loader') {
            continue
        }

        if (element.classList.contains('oc-dialog')) {
            continue
        }

        if (jQuery(element).parents('#side-menu').length) {
            continue
        }

        fixedElements.push(element)
    }

    for (var i in fixedElements) {
        var element = fixedElements[i]
        var value = window.getComputedStyle(element, null).getPropertyValue('left')
        var intValue = parseInt(value.replace('px', ''))

        element.style.setProperty('transform', 'translateX(' + (intValue + 50) + 'px)')
    }
}

window.setTimeout(alwaysDisplayed, 200)
