/**
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

let elements = []

const selector = '#side-menu-message';

const userConfig = (name, value, callbacks) => {
    const url = OC.generateUrl('/apps/side_menu/personalSetting/valueSet')

    $.post(url, {name: name, value: value}, callbacks.success)
        .fail(callbacks.error)
}

const appConfig = (name, value, callbacks) => {
    OCP.AppConfig.setValue('side_menu', name, value, callbacks)
}

const saveSettings = (key) => {
    const element = elements.get(key)
    let value
    let name

    if (jQuery(element).is('[data-checkbox]')) {
        name = jQuery(element).attr('data-name')
        const inputs = jQuery('input[name="' + name + '[]"]:checked')
        value = []

        inputs.each((i, v) => {
            value.push(v.value)
        })

        value = JSON.stringify(value)
    } else {
        name = jQuery(element).attr('name')
        value = jQuery(element).val()
    }

    const size = elements.length

    if (name === 'cache') {
        ++value
    }

    const callbacks = {
        success: () => {
            OC.msg.finishedSuccess(
                selector,
                t('side_menu', (key + 1) + '/' + size)
            )

            if (key < size - 1) {
                saveSettings(++key)
            } else {
                OC.msg.finishedSuccess(selector, t('side_menu', 'Saved'))
            }
        },
        error: () => {
            OC.msg.finishedError(selector, t('side_menu', 'Error while saving "' + element + '"'))
        }
    }

    if (jQuery(element).is('[data-personal]')) {
        userConfig(name, value, callbacks)
    } else {
        appConfig(name, value, callbacks)
    }
}

const elementToggler = (element) => {
    jQuery(element).toggle()
}

jQuery(document).ready(() => {
    elements = jQuery('.side-menu-setting')

    jQuery('#side-menu-save').on('click', (event) => {
        event.preventDefault()
        OC.msg.startSaving(selector)

        saveSettings(0)
    });

    jQuery('.side-menu-display').on('click', (event) => {
        var target = jQuery(event.target)

        jQuery('.side-menu-display').removeClass('is-active')
        target.addClass('is-active')

        jQuery('#side-menu-always-displayed').val(target.attr('data-alwaysdiplayed'))
        jQuery('#side-menu-big-menu').val(target.attr('data-bigmenu'))
    })

    jQuery('.side-menu-setting-live').on('change', (event) => {
        var target = jQuery(event.target)
        var name = target.attr('name')
        var value = target.val()

        if (name === 'opener') {
            var url = OC.generateUrl(`/apps/side_menu/img/${value}.svg`).replace('/index.php', '')

            value = `url(${url})`;
        }

        if (name === 'icon-invert-filter' || name === 'icon-opacity') {
            value/=100;
        }

        document.documentElement.style.setProperty('--side-menu-' + name, value)
    })

    jQuery('.side-menu-toggler').on('click', (event) => {
        var target = jQuery(event.target)
        var element = target.attr('data-target')

        elementToggler(element)
    })
});
