<?php
/**
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace OCA\SideMenu\Settings;

use OCA\SideMenu\Service\AppRepository;
use OCP\AppFramework\Http\TemplateResponse;
use OCP\IConfig;
use OCP\IL10N;
use OCP\ILogger;
use OCP\Settings\ISettings;
use OCA\SideMenu\AppInfo\Application;

class Admin implements ISettings
{
    /**
     * @var IL10N
     */
    private $l;

    /**
     * @var ILogger
     */
    private $logger;

    /**
     * @var IConfig
     */
    private $config;

    /**
     * @var AppRepository
     */
    private $appRepository;

    public function __construct(IL10N $l, ILogger $logger, IConfig $config, AppRepository $appRepository)
    {
        $this->l = $l;
        $this->logger = $logger;
        $this->config = $config;
        $this->appRepository = $appRepository;
    }

    /**
     * @return TemplateResponse
     */
    public function getForm()
    {
        $backgroundColor = $this->config->getAppValue(Application::APP_ID, 'background-color', '#333333');
        $backgroundColorTo = $this->config->getAppValue(Application::APP_ID, 'background-color-to', $backgroundColor);

        $parameters = [
            'background-color' => $backgroundColor,
            'background-color-to' => $backgroundColorTo,
            'current-app-background-color' => $this->config->getAppValue(Application::APP_ID, 'current-app-background-color', '#444444'),
            'loader-color' => $this->config->getAppValue(Application::APP_ID, 'loader-color', '#0e75ac'),
            'icon-invert-filter' => (int) $this->config->getAppValue(Application::APP_ID, 'icon-invert-filter', '0'),
            'icon-opacity' => (int) $this->config->getAppValue(Application::APP_ID, 'icon-opacity', '100'),
            'loader-enabled' => $this->config->getAppValue(Application::APP_ID, 'loader-enabled', '1'),
            'text-color' => $this->config->getAppValue(Application::APP_ID, 'text-color', '#FFFFFF'),
            'cache' => $this->config->getAppValue(Application::APP_ID, 'cache', '0'),
            'opener' => $this->config->getAppValue(Application::APP_ID, 'opener', 'side-menu-opener'),
            'always-displayed' => $this->config->getAppValue(Application::APP_ID, 'always-displayed', '0'),
            'big-menu' => $this->config->getAppValue(Application::APP_ID, 'big-menu', '0'),
            'display-logo' => $this->config->getAppValue(Application::APP_ID, 'display-logo', '1'),
            'use-avatar' => $this->config->getAppValue(Application::APP_ID, 'use-avatar', '0'),
            'opener-position' => $this->config->getAppValue(Application::APP_ID, 'opener-position', 'before'),
            'opener-hover' => $this->config->getAppValue(Application::APP_ID, 'opener-hover', '0'),
            'opener-only' => $this->config->getAppValue(Application::APP_ID, 'opener-only', '0'),
            'hide-when-no-apps' => $this->config->getAppValue(Application::APP_ID, 'hide-when-no-apps', '0'),
            'size-icon' => $this->config->getAppValue(Application::APP_ID, 'size-icon', 'normal'),
            'size-text' => $this->config->getAppValue(Application::APP_ID, 'size-text', 'normal'),
            'target-blank-apps' => (array) json_decode($this->config->getAppValue(Application::APP_ID, 'target-blank-apps', '[]'), true),
            'top-menu-apps' => (array) json_decode($this->config->getAppValue(Application::APP_ID, 'top-menu-apps', '[]'), true),
            'apps' => $this->appRepository->getVisibleApps(),
        ];

        return new TemplateResponse(Application::APP_ID, 'settings/admin-form', $parameters, '');
    }

    /**
     * @return string the section ID, e.g. 'sharing'
     */
    public function getSection()
    {
        return Application::APP_ID;
    }

    /**
     * @return int whether the form should be rather on the top or bottom of
     *             the admin section. The forms are arranged in ascending order of the
     *             priority values. It is required to return a value between 0 and 100.
     *
     * E.g.: 70
     */
    public function getPriority()
    {
        return 70;
    }
}
