<?php

function showUsageAndExit(int $code)
{
    global $argv;

    echo "${argv[0]} [--help] --config /path/to/config/config.php --file /path/to/config.json\n";

    exit($code);
}

function value(string $shortName, string $longName, array $options, bool $required = true): ?string
{
    $value = $options[$shortName] ?? $options[$longName] ?? null;

    if (is_array($value)) {
        echo "To much --{$longName}\n";
        showUsageAndExit(1);
    }

    if (empty($value) && $required) {
        echo "--{$longName} is missing\n";
        showUsageAndExit(1);
    }

    return $value;
}

$options = getopt('t:f:c:h', [
    'type:',
    'file:',
    'config:',
    'help',
]);

$help = value('h', 'help', $options, false);
$config = value('c', 'config', $options);
$file = value('f', 'file', $options);

if (!is_readable($config) && !is_file($config)) {
    echo "No such file: {$config}\n";

    exit(1);
}

if (!is_readable($file) && !is_file($file)) {
    echo "No such file: {$file}\n";

    exit(1);
}

$appConfig = json_decode(file_get_contents($file), true);

require $config;

if ('mysql' === $CONFIG['dbtype']) {
    $pdo = new \PDO(
        'mysql:host='.$CONFIG['dbhost'].';dbname='.$CONFIG['dbname'],
        $CONFIG['dbuser'],
        $CONFIG['dbpassword']
    );
} elseif ($CONFIG['dbtype']) {
    $pdo = new \PDO(sprintf('sqlite:%s', $CONFIG['datadirectory'].'/owncloud.db'));
} else {
    echo "dbtype is not valid\n";

    exit(1);
}

$stmt = $pdo->prepare('UPDATE '.$CONFIG['dbtableprefix'].'appconfig SET configvalue=:value WHERE configkey=:key and appid=:appId');

foreach ($appConfig as $key => $value) {
    $stmt->execute([
        'appId' => 'side_menu',
        'key' => $key,
        'value' => $value,
    ]);
}
