<?php
/**
 * Generates l10n files using Yaml.
 *
 * Usage:
 *   php bin/generate_l10n.php
 */

function generateJsContent($translations)
{
    $json = json_encode($translations, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

    return <<< EOF
OC.L10N.register("side_menu", {$json}, "nplurals=6; plural=n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 && n%100<=99 ? 4 : 5;");
EOF;
}

function generateJsonContent($translations)
{
    $datas = [
        'translations' => $translations,
        'pluralForm' => 'nplurals=6; plural=n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 && n%100<=99 ? 4 : 5;',
    ];

    return json_encode(
        $datas,
        JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE
    );
}

chdir(__DIR__.'/../');

foreach (glob('src/l10n/fixtures/*.yaml') as $file) {
    echo "$file\n";
    $lang = str_replace('.yaml', '', basename($file));
    $translations = yaml_parse(file_get_contents($file));

    file_put_contents('l10n/'.$lang.'.js', generateJsContent($translations));
    file_put_contents('l10n/'.$lang.'.json', generateJsonContent($translations));
}
